package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.TecnicoOsalan;

/**
 * P5304s00DaoImpl generated by UDA, 14-jun-2017 11:55:53.
 * @author UDA
 */
 
@Repository
@Transactional
public class TecnicoOsalanDaoImpl implements TecnicoOsalanDao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<TecnicoOsalan> rwMap = new RowMapper<TecnicoOsalan>() {
		public TecnicoOsalan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new TecnicoOsalan(
               resultSet.getString("T04TABLA"), resultSet.getString("T04ELE"), resultSet.getString("T04DCAST"), resultSet.getString("T04DEUSK"), resultSet.getString("T04BAJA")
           ); } } ;
           
	private RowMapper<TecnicoOsalan> rwMapPK = new RowMapper<TecnicoOsalan>() {
		public TecnicoOsalan mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new TecnicoOsalan(
				resultSet.getString("T04TABLA"), resultSet.getString("T04ELE"), resultSet.getString("T04DCAST"), resultSet.getString("T04DEUSK"), resultSet.getString("T04BAJA")
           ); } } ;

	
	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource DataSource
	 *
	 * @param dataSource the new data source
	 */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
	 * Inserts a single row in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  P5304s00
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the tecnico osalan
	 */
	public TecnicoOsalan add(TecnicoOsalan p5304s00) {
    	String query = "INSERT INTO P5304S00 (T04_TABLA, T04_ELE, T04_DCAST, T04_DEUSK, T04_BAJA) VALUES (?,?,?,?,?)";
		this.jdbcTemplate.update(query, p5304s00.getT04Tabla(), p5304s00.getT04Ele(), p5304s00.getT04Dcast(), p5304s00.getT04Deusk(), p5304s00.getT04Baja());
		return p5304s00;
	}

    /**
     * Updates a single row in the P5304s00 table.
     * 
     *  p5304s00 P5304s00
     *  P5304s00
     *
     * @param p5304s00 the p 5304 s 00
     * @return the tecnico osalan
     */
    public TecnicoOsalan update(TecnicoOsalan p5304s00) {
		String query = "UPDATE P5304S00 SET  WHERE T04_TABLA=? AND T04_ELE=? AND T04_DCAST=? AND T04_DEUSK=? AND T04_BAJA=?";
		this.jdbcTemplate.update(query, p5304s00.getT04Tabla(), p5304s00.getT04Ele(), p5304s00.getT04Dcast(), p5304s00.getT04Deusk(), p5304s00.getT04Baja());
		return p5304s00;
	}

    /**
     * Finds a single row in the P5304s00 table.
     * 
     *  p5304s00 P5304s00
     *  P5304s00
     *
     * @param p5304s00 the p 5304 s 00
     * @return the tecnico osalan
     */
    @Transactional (readOnly = true)
    public TecnicoOsalan find(TecnicoOsalan p5304s00) {
		String query = "SELECT t1.T04_TABLA T04TABLA, t1.T04_ELE T04ELE, t1.T04_DCAST T04DCAST, t1.T04_DEUSK T04DEUSK, t1.T04_BAJA T04BAJA FROM P5304S00 t1  WHERE t1.T04_TABLA = ?   AND t1.T04_ELE = ?   AND t1.T04_DCAST = ?   AND t1.T04_DEUSK = ?   AND t1.T04_BAJA = ?  ";
		
		List<TecnicoOsalan> p5304s00List = this.jdbcTemplate.query(query, this.rwMap, p5304s00.getT04Tabla() , p5304s00.getT04Ele() , p5304s00.getT04Dcast() , p5304s00.getT04Deusk() , p5304s00.getT04Baja());
		return (TecnicoOsalan) DataAccessUtils.uniqueResult(p5304s00List);
    }

    /**
     * Removes a single row in the P5304s00 table.
     * 
     *  p5304s00 P5304s00
     *
     * @param p5304s00 the p 5304 s 00
     */
    public void remove(TecnicoOsalan p5304s00) {
		String query = "DELETE FROM P5304S00 WHERE T04_TABLA=? AND T04_ELE=? AND T04_DCAST=? AND T04_DEUSK=? AND T04_BAJA=?";
		this.jdbcTemplate.update(query, p5304s00.getT04Tabla() , p5304s00.getT04Ele() , p5304s00.getT04Dcast() , p5304s00.getT04Deusk() , p5304s00.getT04Baja());
    }
    
   /**
    * Finds a list of rows in the P5304s00 table.
    * 
    *  p5304s00 P5304s00
    *  jqGridRequestDto JQGridRequestDto
    *  List<P5304s00>
    *
    * @param p5304s00 the p 5304 s 00
    * @param jqGridRequestDto the jq grid request dto
    * @return the list
    */
	@Transactional (readOnly = true)
    public List<TecnicoOsalan> findAll(TecnicoOsalan p5304s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.T04_TABLA T04TABLA,t1.T04_ELE T04ELE,t1.T04_DCAST T04DCAST,t1.T04_DEUSK T04DEUSK,t1.T04_BAJA T04BAJA "); 
		query.append("FROM P5304S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(p5304s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<TecnicoOsalan>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the P5304s00 table using like.
	 * 
	 *  p5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<P5304s00>
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional (readOnly = true)
    public List<TecnicoOsalan> findAllLike(TecnicoOsalan p5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.T04_TABLA T04TABLA,t1.T04_ELE T04ELE,t1.T04_DCAST T04DCAST,t1.T04_DEUSK T04DEUSK,t1.T04_BAJA T04BAJA "); 
        query.append("FROM P5304S00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(p5304s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<TecnicoOsalan>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
	 * Counts rows in the P5304s00 table.
	 * 
	 *  p5304s00 P5304s00
	 *  Long
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the long
	 */
    @Transactional (readOnly = true)
    public Long findAllCount(TecnicoOsalan p5304s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM P5304S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(p5304s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the P5304s00 table using like.
	 * 
	 *  p5304s00 P5304s00
	 *  startsWith Boolean
	 *  Long
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(TecnicoOsalan p5304s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM P5304S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(p5304s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of P5304s00 selected for rup_table.
	 * 
	 *  p5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<P5304s00>>
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override 
	public List<TableRowDto<TecnicoOsalan>> reorderSelection(TecnicoOsalan p5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T04_TABLA T04TABLA,t1.T04_ELE T04ELE,t1.T04_DCAST T04DCAST,t1.T04_DEUSK T04DEUSK,t1.T04_BAJA T04BAJA "); 
		// FROM
        query.append("FROM P5304S00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(p5304s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, TecnicoOsalan.class, filterParamList, "T04_TABLA,T04_ELE,T04_DCAST,T04_DEUSK,T04_BAJA" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<TecnicoOsalan>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams P5304s00
	 *  searchParams P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<P5304s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<TecnicoOsalan>> search(TecnicoOsalan filterParams, TecnicoOsalan searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.T04_TABLA T04TABLA,t1.T04_ELE T04ELE,t1.T04_DCAST T04DCAST,t1.T04_DEUSK T04DEUSK,t1.T04_BAJA T04BAJA "); 
		// FROM
        query.append("FROM P5304S00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, TecnicoOsalan.class, filterParamList, searchSQL, searchParamList, from_alias, "T04_TABLA,T04_ELE,T04_DCAST,T04_DEUSK,T04_BAJA");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<TecnicoOsalan>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterp5304s00 P5304s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filterp5304s00 the filterp 5304 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(TecnicoOsalan filterp5304s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.T04_TABLA T04TABLA,t1.T04_ELE T04ELE,t1.T04_DCAST T04DCAST,t1.T04_DEUSK T04DEUSK,t1.T04_BAJA T04BAJA "); 
		// FROM
        query.append("FROM P5304S00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterp5304s00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, TecnicoOsalan.class, query, params, "T04_TABLA,T04_ELE,T04_DCAST,T04_DEUSK,T04_BAJA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}


	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the P5304s00 entity .
	 * 
	 *  p5304s00 P5304s00
	 *            Bean with the criteria values to filter by.
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (TecnicoOsalan p5304s00){
		
		StringBuilder where = new StringBuilder(TecnicoOsalanDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (p5304s00  != null  && p5304s00.getT04Tabla() != null ) {
			where.append(" AND t1.T04_TABLA = ?");
			params.add(p5304s00.getT04Tabla());
		}
		if (p5304s00  != null  && p5304s00.getT04Ele() != null ) {
			where.append(" AND t1.T04_ELE = ?");
			params.add(p5304s00.getT04Ele());
		}
		if (p5304s00  != null  && p5304s00.getT04Dcast() != null ) {
			where.append(" AND t1.T04_DCAST = ?");
			params.add(p5304s00.getT04Dcast());
		}
		if (p5304s00  != null  && p5304s00.getT04Deusk() != null ) {
			where.append(" AND t1.T04_DEUSK = ?");
			params.add(p5304s00.getT04Deusk());
		}
		if (p5304s00  != null  && p5304s00.getT04Baja() != null ) {
			where.append(" AND t1.T04_BAJA = ?");
			params.add(p5304s00.getT04Baja());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the P5304s00 entity .
	 * 
	 *  p5304s00 P5304s00
	 *            Bean with the criteria values to filter by.
	 *  startsWith Boolean
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param p5304s00 the p 5304 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (TecnicoOsalan p5304s00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(TecnicoOsalanDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (p5304s00  != null  && p5304s00.getT04Tabla() != null ) {
			where.append(" AND UPPER(t1.T04_TABLA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(p5304s00.getT04Tabla().toUpperCase() +"%");
			}else{
				params.add("%"+p5304s00.getT04Tabla().toUpperCase() +"%");
			}
			where.append(" AND t1.T04_TABLA IS NOT NULL");
	     }			
		if (p5304s00  != null  && p5304s00.getT04Ele() != null ) {
			where.append(" AND UPPER(t1.T04_ELE) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(p5304s00.getT04Ele().toUpperCase() +"%");
			}else{
				params.add("%"+p5304s00.getT04Ele().toUpperCase() +"%");
			}
			where.append(" AND t1.T04_ELE IS NOT NULL");
	     }			
		if (p5304s00  != null  && p5304s00.getT04Dcast() != null ) {
			where.append(" AND UPPER(t1.T04_DCAST) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(p5304s00.getT04Dcast().toUpperCase() +"%");
			}else{
				params.add("%"+p5304s00.getT04Dcast().toUpperCase() +"%");
			}
			where.append(" AND t1.T04_DCAST IS NOT NULL");
	     }			
		if (p5304s00  != null  && p5304s00.getT04Deusk() != null ) {
			where.append(" AND UPPER(t1.T04_DEUSK) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(p5304s00.getT04Deusk().toUpperCase() +"%");
			}else{
				params.add("%"+p5304s00.getT04Deusk().toUpperCase() +"%");
			}
			where.append(" AND t1.T04_DEUSK IS NOT NULL");
	     }			
		if (p5304s00  != null  && p5304s00.getT04Baja() != null ) {
			where.append(" AND UPPER(t1.T04_BAJA) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(p5304s00.getT04Baja().toUpperCase() +"%");
			}else{
				params.add("%"+p5304s00.getT04Baja().toUpperCase() +"%");
			}
			where.append(" AND t1.T04_BAJA IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

